package org.jboss.test.jmx.shutdown;

import javax.naming.InitialContext;

import org.jboss.system.ServiceMBeanSupport;

/** A service that calls System.exit from its stopService method
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1 $
 */
public class ExitOnShutdown
   extends ServiceMBeanSupport
   implements ExitOnShutdownMBean
{
   protected void startService() throws Exception
   {
      InitialContext ctx = new InitialContext();
      ctx.bind("ExitOnShutdown", Boolean.TRUE);
   }

   protected void stopService() throws Exception
   {
      System.exit(0);
   }
}
