/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jmx.test;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

import junit.framework.Test;

import org.jboss.system.ServiceMBean;
import org.jboss.test.JBossTestCase;
import org.jboss.deployment.IncompleteDeploymentException;

public class NoInternalJBossUnitTestCase extends JBossTestCase
{
   // Attributes ----------------------------------------------------

   public NoInternalJBossUnitTestCase( String name )
   {
      super( name );
   }

   public static Test suite()
      throws Exception
   {
      return getDeploySetup(NoInternalJBossUnitTestCase.class, "jmx-nointernal.sar");
   }

   public void testNoInternalJBossLifecycle() throws Exception
   {
      Integer state = (Integer) getServer().getAttribute(getObjectName(), "State");
      assertTrue("Should be started", state.intValue() == ServiceMBean.STARTED);
   }
   
   ObjectName getObjectName() throws MalformedObjectNameException
   {
      return new ObjectName("jboss.test:service=NoInternalJBoss");
   }
}
