/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.security.test;

import java.net.URL;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;

import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.test.JBossTestCase;
import org.jboss.test.JBossTestSetup;
import org.jboss.test.security.interfaces.CustomPrincipalHome;
import org.jboss.test.security.interfaces.CustomPrincipal;
import org.jboss.test.security.ejb.CustomPrincipalImpl;
import org.jboss.test.util.AppCallbackHandler;
import org.jboss.test.util.web.HttpUtils;

import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;


/** JAAS specific tests.
 
 @author Scott.Stark@jboss.org
 @version $Revision: 1.1.2.4 $
 */
public class JaasUnitTestCase
   extends JBossTestCase
{
   static String username = "jduke";
   static char[] password = "theduke".toCharArray();
   
   LoginContext lc;
   boolean loggedIn;

   public JaasUnitTestCase(String name)
   {
      super(name);
   }

   /** Test return of a custom principal from getCallerPrincipal.
    */
   public void testCustomEJBPrincipal() throws Exception
   {
      login();
      log.debug("+++ testCustomEJBPrincipal()");
      Object obj = getInitialContext().lookup("jaas.CustomPrincipalHome");
      obj = PortableRemoteObject.narrow(obj, CustomPrincipalHome.class);
      CustomPrincipalHome home = (CustomPrincipalHome) obj;
      log.debug("Found CustomPrincipalHome");
      CustomPrincipal bean = home.create();
      log.debug("Created CustomPrincipal");
      
      boolean isCustomType = bean.validateCallerPrincipal(CustomPrincipalImpl.class);
      bean.remove();
      logout();
      assertTrue("CustomPrincipalImpl was seen", isCustomType);
   }

   /** Test return of a custom principal from getCallerPrincipal coming from
    * a custom login module.
    */
   public void testCustomEJBPrincipal2() throws Exception
   {
      login();
      log.debug("+++ testCustomEJBPrincipal()");
      Object obj = getInitialContext().lookup("jaas.CustomPrincipal2Home");
      obj = PortableRemoteObject.narrow(obj, CustomPrincipalHome.class);
      CustomPrincipalHome home = (CustomPrincipalHome) obj;
      log.debug("Found CustomPrincipalHome");
      CustomPrincipal bean = home.create();
      log.debug("Created CustomPrincipal");
      
      boolean isCustomType = bean.validateCallerPrincipal(CustomPrincipalImpl.class);
      bean.remove();
      logout();
      assertTrue("CustomPrincipalImpl was seen", isCustomType);
   }

   public void testCustomWebPrincipal() throws Exception
   {
      log.debug("+++ testCustomWebPrincipal()");
      String base = HttpUtils.getBaseURL();
      URL testURL = new URL(base + "jaas/CustomPrincipalServlet"
         +"?type="+CustomPrincipalImpl.class.getName());
      HttpUtils.accessURL(testURL);
   }

   /** Login as user scott using the conf.name login config or
    'jaas-test' if conf.name is not defined.
    */
   private void login() throws Exception
   {
      login(username, password);
   }
   private void login(String username, char[] password) throws Exception
   {
      if( loggedIn )
         return;
      
      lc = null;
      String confName = System.getProperty("conf.name", "jaas-test");
      AppCallbackHandler handler = new AppCallbackHandler(username, password);
      log.debug("Creating LoginContext("+confName+")");
      lc = new LoginContext(confName, handler);
      lc.login();
      log.debug("Created LoginContext, subject="+lc.getSubject());
      loggedIn = true;
   }
   private void logout() throws Exception
   {
      if( loggedIn )
      {
         loggedIn = false;
         lc.logout();
      }
   }


   /**
    * Setup the test suite.
    */
   public static Test suite() throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(JaasUnitTestCase.class));

      // Create an initializer for the test suite
      TestSetup wrapper = new JBossTestSetup(suite)
      {
         protected void setUp() throws Exception
         {
            super.setUp();
            Configuration.setConfiguration(new XMLLoginConfigImpl());
            deploy("security-jaas.ear");
            flushAuthCache("jaas-test");
         }
         protected void tearDown() throws Exception
         {
            undeploy("security-jaas.ear");
            super.tearDown();
         
         }
      };
      return wrapper;
   }

}
