/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.security.test;

import java.util.Map;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.AppConfigurationEntry.LoginModuleControlFlag;

import org.apache.log4j.Logger;

import org.jboss.logging.XLevel;
import org.jboss.security.auth.login.XMLLoginConfigImpl;

/** Tests of the LoginModule classes using the XMLLoginConfigImpl implementation
 of the JAAS login module configuration.
 
 @author Scott.Stark@jboss.org
 @version $Revision: 1.2.2.2 $
 */
public class XMLLoginModulesUnitTestCase extends LoginModulesUnitTestCase
{

   public XMLLoginModulesUnitTestCase(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      // Setup the replacement properties
      System.setProperty("testPropertyReplacement.required", "required");
      System.setProperty("users.properties", "/security/config/users.properites");
      System.setProperty("roles.properties", "/security/config/roles.properites");

      // Install the custom JAAS configuration
      XMLLoginConfigImpl config = new XMLLoginConfigImpl();
      config.setConfigResource("login-config.xml");
      config.loadConfig();
      Configuration.setConfiguration(config);

      // Turn on trace level logging
      Logger root = Logger.getRootLogger();
      root.setLevel(XLevel.TRACE);
   }

   public void testPropertyReplacement() throws Exception
   {
      Configuration config = Configuration.getConfiguration();
      AppConfigurationEntry[] entries = config.getAppConfigurationEntry("testPropertyReplacement");
      assertTrue("entries.length == 1", entries.length == 1);
      AppConfigurationEntry entry = entries[0];
      LoginModuleControlFlag flag = entry.getControlFlag();
      assertTrue("flag == required", flag == LoginModuleControlFlag.REQUIRED);
      Map options = entry.getOptions();
      String users = (String) options.get("usersProperties");
      assertTrue("usersProperties("+users+") = /security/config/users.properites",
         users.equals("/security/config/users.properites"));
      String roles = (String) options.get("rolesProperties");
      assertTrue("rolesProperties("+roles+") = /security/config/roles.properites",
         roles.equals("/security/config/roles.properites"));
   }
}
