/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.testbeancluster.bean;


import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;

import org.jboss.test.testbean.interfaces.AComplexPK;
import org.apache.log4j.Category;

/** Tests of the cluster cache invalidation framework.
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.1 $
 */ 
public abstract class EntityPKBean implements EntityBean
{
   private static Category log = Category.getInstance(EntityPKBean.class);

   private EntityContext entityContext;

   public AComplexPK ejbCreate(boolean aBoolean, int anInt, long aLong,
      double aDouble, String aString)
      throws CreateException
   {
      log.debug("ejbCreate() called");
      updateAllValues(new AComplexPK(aBoolean, anInt, aLong, aDouble, aString));
      return null;
   }

   public AComplexPK ejbCreateMETHOD(boolean aBoolean, int anInt, long aLong,
      double aDouble, String aString)
      throws CreateException
   {
      log.debug("ejbCreateMETHOD() called");
      updateAllValues(new AComplexPK(aBoolean, anInt, aLong, aDouble, aString));
      return null;
   }

   public void ejbPostCreate(boolean aBoolean, int anInt, long aLong,
      double aDouble, String aString)
      throws CreateException
   {
      log.debug("ejbPostCreate(pk) called");
   }

   public void ejbPostCreateMETHOD(boolean aBoolean, int anInt, long aLong,
      double aDouble, String aString)
      throws CreateException
   {
      log.debug("ejbPostCreateMETHOD(pk) called");
   }

   public void ejbActivate()
   {
      log.debug("ejbActivate() called");
   }

   public void ejbLoad()
   {
      log.debug("ejbLoad() called");
   }

   public void ejbPassivate()
   {
      log.debug("ejbPassivate() called");
   }

   public void ejbRemove() throws RemoveException
   {

      log.debug("EntityPK.ejbRemove() called");
   }
   public void ejbStore()
   {
      log.debug("ejbStore() called");
   }

   public void setEntityContext(EntityContext context)
   {
      log.debug("setSessionContext() called");
      entityContext = context;
   }

   public void unsetEntityContext()
   {
      log.debug("unsetSessionContext() called");
      entityContext = null;
   }

   public void updateAllValues(AComplexPK aComplexPK)
   {
      setABoolean(aComplexPK.aBoolean);
      setADouble(aComplexPK.aDouble);
      setALong(aComplexPK.aLong);
      setAnInt(aComplexPK.anInt);
      setAString(aComplexPK.aString);
   }

   public AComplexPK readAllValues()
   {
      return new AComplexPK(getABoolean(), getAnInt(), getALong(), getADouble(),
         getAString());
   }

   public abstract boolean getABoolean();
   public abstract void setABoolean(boolean value);

   public abstract double getADouble();
   public abstract void setADouble(double value);

   public abstract long getALong();
   public abstract void setALong(long value);

   public abstract int getAnInt();
   public abstract void setAnInt(int value);

   public abstract String getAString();
   public abstract void setAString(String value);

   public abstract int getOtherField();
   public abstract void setOtherField(int newValue);

}
