/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.testbeancluster.bean;

import java.rmi.RemoteException;
import javax.ejb.SessionBean;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;

import org.jboss.test.testbeancluster.interfaces.StatelessSessionHome;
import org.jboss.test.testbeancluster.interfaces.StatelessSession;

public class StatelessSessionBean implements SessionBean
{
   public static long numberOfCalls = 0;

   public void ejbCreate()
   {
   }
   public void ejbActivate() throws EJBException, RemoteException
   {
   }

   public void ejbPassivate() throws EJBException, RemoteException
   {
   }

   public void ejbRemove() throws EJBException, RemoteException
   {
   }

   public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException
   {
   }

   public void callBusinessMethodA()
   {
      numberOfCalls++;
   }
   
   public String callBusinessMethodB(String jndiURL)
   {
      numberOfCalls++;
      String rtn = "callBusinessMethodB-" + numberOfCalls;
      testColocation(jndiURL);
      return rtn;
   }

   public void testColocation(String jndiURL)
   {
      try
      {
         System.out.println("begin testColocation");
         InitialContext ctx = new InitialContext();
         if( jndiURL == null )
            jndiURL = "jnp://localhost:1100/nextgen_StatelessSession";
         StatelessSessionHome home = (StatelessSessionHome) ctx.lookup(jndiURL);
         StatelessSession session = home.create();
         session.callBusinessMethodA();
         System.out.println("end testColocation");
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
      }

   }
   
   public void resetNumberOfCalls ()
   {
      System.out.println("Number of calls has been reseted");
      numberOfCalls = 0;
   }
   
   public void makeCountedCall ()
   {
      System.out.println("makeCountedCall called");
      numberOfCalls++;
   }
   
   public long getCallCount ()
   {
      System.out.println("getCallCount called");
      return numberOfCalls;
   }

}
