package org.jboss.test.web.servlets;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.FilterChain;
import javax.security.auth.Subject;
import javax.naming.NamingException;
import javax.naming.InitialContext;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1 $
 */
public class SubjectFilter implements Filter
{
   public void init(FilterConfig filterConfig) throws ServletException
   {
      
   }

   public void doFilter(ServletRequest request, ServletResponse response,
      FilterChain filterChain)
      throws IOException, ServletException
   {
      try
      {
         Subject userSubject = getActiveSubject();
         if( userSubject == null )
            throw new ServletException("Active subject was null");
      }
      catch(NamingException e)
      {
         throw new ServletException("Failed to lookup active subject", e);        
      }
      filterChain.doFilter(request, response);
   }

   public void destroy()
   {
   }

   protected Subject getActiveSubject() throws NamingException
   {
      InitialContext ctx = new InitialContext();
      Subject s = (Subject) ctx.lookup("java:comp/env/security/subject");
      return s;
   }
}
