/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.web.test.ssl;

import java.net.HttpURLConnection;

import junit.framework.Test;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.test.JBossTestCase;

/** Tests of ssl and CLIENT-CERT auth
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.2 $
 */
public class SSLUnitTestCase extends JBossTestCase
{
   private String baseHttpNoAuth = "http://localhost:" + Integer.getInteger("web.port", 8080) + "/"; 
   private String baseHttpsNoAuth = "https://localhost:" + Integer.getInteger("web.port", 8443) + "/"; 

   public SSLUnitTestCase(String name)
   {
      super(name);
   }

   /** Test that access of the transport constrained 
    * 
    * @throws Exception
    */ 
   public void testHttpRedirect() throws Exception
   {
      log.info("+++ testHttpRedirect");
      // Start by accessing the secured index.html of war1
      HttpClient httpConn = new HttpClient();
      String url = baseHttpNoAuth+"clientcert-auth/unrestricted/SecureServlet";
      log.info("Accessing: "+url);
      GetMethod get = new GetMethod(url);
      int responseCode = httpConn.executeMethod(get);
      String status = get.getStatusText();
      log.debug(status);
      assertTrue("Get HTTP_MOVED_TEMP("+responseCode+")", responseCode == HttpURLConnection.HTTP_MOVED_TEMP);

      Header hdr = get.getResponseHeader("Location");
      url = hdr.getValue();
      get = new GetMethod(url);
      responseCode = httpConn.executeMethod(get);
      status = get.getStatusText();
      log.debug(status);
      assertTrue("Get OK("+responseCode+")", responseCode == HttpURLConnection.HTTP_OK);
   }

   /** Test that access of the transport constrained 
    * 
    * @throws Exception
    */ 
   public void testHttps() throws Exception
   {
      log.info("+++ testHttps");
      // Start by accessing the secured index.html of war1
      HttpClient httpConn = new HttpClient();
      String url = baseHttpsNoAuth+"clientcert-auth/unrestricted/SecureServlet";
      log.info("Accessing: "+url);
      GetMethod get = new GetMethod(url);
      int responseCode = httpConn.executeMethod(get);
      String status = get.getStatusText();
      log.debug(status);
      assertTrue("Get OK("+responseCode+")", responseCode == HttpURLConnection.HTTP_OK);
   }

   /** One time setup for all SingleSignOnUnitTestCase unit tests
    */
   public static Test suite() throws Exception
   {
      Test suite = getDeploySetup(SSLUnitTestCase.class, "clientcert-auth.war");
      return suite;
   }
}
