package org.jboss.web.tomcat.tc4;

import javax.management.ObjectName;
import javax.management.MBeanServer;
import org.jboss.web.tomcat.statistics.InvocationStatistics;

/** The tomcat deployer configuration information passed from the web container.
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.2 $
 */
public class DeployerConfig
{
   /** The parent class loader first model flag */
   protected boolean java2ClassLoadingCompliance = false;
   /** A flag indicating if war archives should be unpacked */
   protected boolean unpackWars = true;
   /** If true, ejb-links that don't resolve don't cause an error (fallback to jndi-name) */
   protected boolean lenientEjbLink = false;
   /** The embedded instance used to configure catalina */
   private EmbeddedCatalina catalina;
   private ObjectName serviceName;
   /** The catalina debug level */
   private int debugLevel;
   /** A flag indicating if the JBoss Loader should be used */
   private boolean useJBossWebLoader = true;
   /** A flag indicating if the working dir for a war deployment should be
    delete when the war is undeployed.
    */
   private boolean deleteWorkDirs = true;
   /** Which snapshot mode should be used in clustered environment?
    Default: instant
    */
   private String snapshotMode = "instant"; // instant or interval
   /** With IntervalSnapshotManager use this interval (in ms) for snapshotting */
   private int snapshotInterval = 1000;

   /** Should the clustering code use caching or not? */
   private boolean useLocalCache = true;

   /** Get the request attribute name under which the JAAS Subject is store */
   private String subjectAttributeName = null;
   /** The web ctx invocation statistics */
   private InvocationStatistics stats;

   public boolean isJava2ClassLoadingCompliance()
   {
      return java2ClassLoadingCompliance;
   }

   public void setJava2ClassLoadingCompliance(boolean java2ClassLoadingCompliance)
   {
      this.java2ClassLoadingCompliance = java2ClassLoadingCompliance;
   }

   public boolean isUnpackWars()
   {
      return unpackWars;
   }

   public void setUnpackWars(boolean unpackWars)
   {
      this.unpackWars = unpackWars;
   }

   public boolean isLenientEjbLink()
   {
      return lenientEjbLink;
   }

   public void setLenientEjbLink(boolean lenientEjbLink)
   {
      this.lenientEjbLink = lenientEjbLink;
   }

   public EmbeddedCatalina getCatalina()
   {
      return catalina;
   }

   public void setCatalina(EmbeddedCatalina catalina)
   {
      this.catalina = catalina;
   }

   public ObjectName getServiceName()
   {
      return serviceName;
   }

   public void setServiceName(ObjectName serviceName)
   {
      this.serviceName = serviceName;
   }

   public int getDebugLevel()
   {
      return debugLevel;
   }

   public void setDebugLevel(int debugLevel)
   {
      this.debugLevel = debugLevel;
   }

   public boolean isUseJBossWebLoader()
   {
      return useJBossWebLoader;
   }

   public void setUseJBossWebLoader(boolean useJBossWebLoader)
   {
      this.useJBossWebLoader = useJBossWebLoader;
   }

   public boolean isDeleteWorkDirs()
   {
      return deleteWorkDirs;
   }

   public void setDeleteWorkDirs(boolean deleteWorkDirs)
   {
      this.deleteWorkDirs = deleteWorkDirs;
   }

   public String getSnapshotMode()
   {
      return snapshotMode;
   }

   public void setSnapshotMode(String snapshotMode)
   {
      this.snapshotMode = snapshotMode;
   }

   public int getSnapshotInterval()
   {
      return snapshotInterval;
   }

   public void setSnapshotInterval(int snapshotInterval)
   {
      this.snapshotInterval = snapshotInterval;
   }

   public String getSubjectAttributeName()
   {
      return subjectAttributeName;
   }

   public void setSubjectAttributeName(String subjectAttributeName)
   {
      this.subjectAttributeName = subjectAttributeName;
   }

   public InvocationStatistics getStats()
   {
      return stats;
   }

   public void setStats(InvocationStatistics stats)
   {
      this.stats = stats;
   }
   public boolean isUseLocalCache()
   {
      return useLocalCache;
   }
   public void setUseLocalCache(boolean useLocalCache)
   {
      this.useLocalCache = useLocalCache;
   }

}
