package org.jboss.web.tomcat.tc5;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSetBase;

/**
 * A rule set for processing the the WEB-INF/context.xml descriptor
 *
 * @author mtkopone@users.sourceforge.net
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.2 $, $Date: 2004/09/13 00:11:23 $
 */
public class ContextConfigRuleSet extends RuleSetBase
{
   /**
    * 
    */
   public ContextConfigRuleSet()
   {
   }

   /**
    * <p>Add the set of Rule instances defined in this RuleSet to the
    * specified <code>Digester</code> instance, associating them with
    * our namespace URI (if any).  This method should only be called
    * by a Digester instance.</p>
    *
    * @param digester Digester instance to which the new Rule instances
    *                 should be added.
    */
   public void addRuleInstances(Digester digester)
   {
      //digester.addObjectCreate("Context","org.apache.catalina.core.StandardContext","className");
      digester.addSetProperties("Context");
      //digester.addRule("Context", new CopyParentClassLoaderRule(digester));
      //digester.addRule("Context",new LifecycleListenerRule(digester,"org.apache.catalina.startup.ContextConfig","configClass"));
      //digester.addSetNext("Context","addChild","org.apache.catalina.Container");
      digester.addCallMethod("Context/InstanceListener", "addInstanceListener", 0);
      digester.addObjectCreate("Context/Listener", null, "className");
      digester.addSetProperties("Context/Listener");
      digester.addSetNext("Context/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
      //digester.addRule("Context/Loader",new CreateLoaderRule(digester,"org.apache.catalina.loader.WebappLoader","className"));
      //digester.addSetProperties("Context/Loader");
      //digester.addSetNext("Context/Loader","setLoader","org.apache.catalina.Loader");

      digester.addObjectCreate("Context/Logger", null, "className");
      digester.addSetProperties("Context/Logger");
      digester.addSetNext("Context/Logger", "setLogger", "org.apache.catalina.Logger");

      digester.addObjectCreate("Context/Manager", "org.apache.catalina.session.StandardManager", "className");
      digester.addSetProperties("Context/Manager");
      digester.addSetNext("Context/Manager", "setManager", "org.apache.catalina.Manager");

      digester.addObjectCreate("Context/Manager/Store", null, "className");
      digester.addSetProperties("Context/Manager/Store");
      digester.addSetNext("Context/Manager/Store", "setStore", "org.apache.catalina.Store");

      digester.addObjectCreate("Context/Parameter", "org.apache.catalina.deploy.ApplicationParameter");
      digester.addSetProperties("Context/Parameter");
      digester.addSetNext("Context/Parameter", "addApplicationParameter", "org.apache.catalina.deploy.ApplicationParameter");

      digester.addObjectCreate("Context/Realm", null, "className");
      digester.addSetProperties("Context/Realm");
      digester.addSetNext("Context/Realm", "setRealm", "org.apache.catalina.Realm");

      digester.addObjectCreate("Context/ResourceLink", "org.apache.catalina.deploy.ContextResourceLink");
      digester.addSetProperties("Context/ResourceLink");
      digester.addSetNext("Context/ResourceLink", "addResourceLink", "org.apache.catalina.deploy.ContextResourceLink");
      digester.addObjectCreate("Context/Resources", "org.apache.naming.resources.FileDirContext", "className");
      digester.addSetProperties("Context/Resources");
      digester.addSetNext("Context/Resources", "setResources", "javax.naming.directory.DirContext");

      digester.addObjectCreate("Context/Valve", null, "className");
      digester.addSetProperties("Context/Valve");
      digester.addSetNext("Context/Valve", "addValve", "org.apache.catalina.Valve");

      digester.addCallMethod("Context/WrapperLifecycle", "addWrapperLifecycle", 0);
      digester.addCallMethod("Context/WrapperListener", "addWrapperListener", 0);
   }
}
