/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.web.tomcat.tc5.session;

import org.apache.catalina.Session;
import org.jboss.logging.Logger;

/**
 * A concrete implementation of the snapshot manager interface
 * that does instant replication of a modified session
 *
 * @author Thomas Peuss <jboss@peuss.de>
 * @version $Revision: 1.1.2.5 $
 */
public class InstantSnapshotManager extends SnapshotManager
{
   static Logger log = Logger.getLogger(InstantSnapshotManager.class);

   public InstantSnapshotManager(AbstractJBossManager manager, String path)
   {
      super(manager, path);
   }

   /**
    * Instant replication of the modified session
    */
   public void snapshot(String id)
   {
      try
      {
         // find the session that has been modified
         Session session = (Session) manager.findSession(id);
         manager.storeSession(session);
      }
      catch (Exception e)
      {
         log.warn("Failed to replicate sessionID:" + id, e);
      }
   }

   public void start()
   {
   }

   public void stop()
   {
   }
}
