/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.monitor;

import org.jboss.system.ServiceMBean;

import javax.management.ObjectName;
import java.util.ArrayList;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 1.1.2.1 $
 *
 **/
public interface JBossMonitorMBean extends ServiceMBean
{
   String getMonitorName();

   void setMonitorName(String name);

   ObjectName getObservedObject();

   void setObservedObject(ObjectName oname);

   String getObservedAttribute();

   void setObservedAttribute(String attr);

   public String getThreshold();
   public void setThreshold(String val);

   boolean getEnabled();

   void setEnabled(boolean start);

   long getPeriod();

   void setPeriod(long period);

   ArrayList getAlertListeners();
   void setAlertListeners(ArrayList listeners);

   public Object getTriggeredAttributeValue();
   public long getTriggerTime();


   boolean alerted();

   void clearAlert();

}
