/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.monitor;

import javax.management.ObjectName;
import java.util.ArrayList;
import java.util.Date;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 1.1.2.1 $
 *
 **/
public interface SnapshotRecordingMonitorMBean
{
   String getMonitorName();

   void setMonitorName(String name);

   ObjectName getObservedObject();

   void setObservedObject(ObjectName oname);

   String getObservedAttribute();

   void setObservedAttribute(String attr);

   long getPeriod();

   void setPeriod(long period);

   ArrayList getData();

   void clearData();

   void startSnapshot();

   void endSnapshot();

   long getStartTime();

   long getEndTime();
   boolean isRecording();

}
