/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.varia.stats.report;

import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.stats.TxStatistics;

import javax.management.ObjectName;
import java.util.Iterator;

/**
 * @jmx:mbean extends="org.jboss.system.ServiceMBean"
 *
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision: 1.1.2.1 $</tt>
 */
public abstract class ReportGenerator
   extends ServiceMBeanSupport
   implements ReportGeneratorMBean
{
   protected ObjectName statsCollector;

   protected String name;
   protected String description;

   /**
    * @jmx.managed-attribute
    */
   public void setName(String name)
   {
      this.name = name;
   }

   /**
    * @jmx.managed-attribute
    */
   public String getName()
   {
      return name;
   }

   /**
    * @jmx.managed-attribute
    */
   public void setDescription(String description)
   {
      this.description = description;
   }

   /**
    * @jmx.managed-attribute
    */
   public String getDescription()
   {
      return description;
   }

   /**
    * @jmx.managed-attribute
    */
   public void setStatsCollector(ObjectName statsCollector)
   {
      this.statsCollector = statsCollector;
   }

   /**
    * @jmx.managed-attribute
    */
   public ObjectName getStatsCollector()
   {
      return statsCollector;
   }

   public void startService() throws Exception
   {
      try
      {
         server.invoke(
            statsCollector,
            "registerReportGenerator",
            new Object[]{this},
            new String[]{ReportGenerator.class.getName()});
      }
      catch(Exception e)
      {
         log.error("Failed to register report generator.");
         throw e;
      }
   }

   public void stopService() throws Exception
   {
      try
      {
         server.invoke(statsCollector,
            "unregisterReportGenerator",
            new Object[]{this},
            new String[]{ReportGenerator.class.getName()});
      }
      catch(Exception e)
      {
         log.error("Failed to unregister report generator.");
         throw e;
      }
   }

   /**
    * @jmx.managed-operation
    */
   public String generate(String reportName) throws Exception
   {
      StringBuffer content = new StringBuffer();
      content.append("<a href='HtmlAdaptor?")
         .append("action=invokeOpByName&name=")
         .append(statsCollector)
         .append("&methodName=reports")
         .append("'>Back to report list</a>");

      content(reportName, content);

      return content.toString();
   }

   // Protected

   protected abstract void content(String reportName, StringBuffer buf) throws Exception;

   protected Iterator getReportsIterator()
      throws Exception
   {
      try
      {
         return (Iterator) server.invoke(statsCollector, "reportsIterator", new Object[]{}, new String[]{});
      }
      catch(Exception e)
      {
         log.error("Failed to invoke getReportsIterator() operation.");
         throw e;
      }
   }

   protected TxStatistics getTxStatistics()
      throws Exception
   {
      try
      {
         return (TxStatistics) server.invoke(statsCollector, "txStatistics", new Object[]{}, new String[]{});
      }
      catch(Exception e)
      {
         log.error("Failed to invoke getTxStatistics() operation.");
         throw e;
      }
   }
}
