/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.web.loadbalancer.scheduler;

/**
 * This class holds statistics for a node.
 *
 * @author Thomas Peuss <jboss@peuss.de>
 * @version $Revision: 1.1.2.1 $
 */
public class HostStatistics
{
  private volatile long sumResponseTime;
  private volatile int numRequests;

  public void addRequest(int responseTime)
  {
    numRequests++;
    sumResponseTime+=responseTime;
  }

  public void reset()
  {
    sumResponseTime=0L;
    numRequests=0;
  }

  public int getAvgResponseTime()
  {
    try
    {
      return (int)(sumResponseTime / (long)numRequests);
    }
    catch (Exception ex)
    {
      return 0;
    }
  }

  public int getNumRequests()
  {
    return numRequests;
  }

  public long getSumResponseTime()
  {
    return sumResponseTime;
  }

  public String toString()
  {
    return "[Requests="+numRequests+", AvgResponseTime="+getAvgResponseTime()+"]";
  }
}