// $Id: CacheListener.java,v 1.7.2.3 2004/08/09 02:53:02 bwang00 Exp $

/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache;

import java.util.Map;

/**
 * Cache notification interface. We can register with a cache ({@link
 * Cache#addListener(CacheListener)}) to receive notifications when
 * modifications are made to the cache.
 *
 * @author <a href="mailto:bela@jboss.org">Bela Ban</a>.
 * @version $Revision: 1.7.2.3 $
 */

public interface CacheListener {

   /**
    * Called after the entire contents of the map have been set. This is more
    * efficient than calling {@link #entrySet(Object,Object,Object)} on each
    * value
    *
    * @param m The new map. Its entries will overwrite whatever is already in
    *          the map.
    */
   void contentsInitialized(Map m);

   /**
    * Called after the entire contents of the map have been deleted
    */
   void contentsCleared();

   /**
    * Called after an entry has been set. This could be the addition of a new
    * entry, or the modification of an existing entry.
    *
    * @param key       The new key
    * @param value     The new value
    * @param old_value The value previously associated with <code>key</code>
    */
   void entrySet(Object key, Object value, Object old_value);

   /**
    * Called after an entry has been removed.
    *
    * @param key       The key identifying the entry
    * @param old_value The old value associated with <code>key</code>
    */
   void entryRemoved(Object key, Object old_value);
}
