/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache;


import org.jgroups.Address;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;


/**
 * Uniquely identifies a transaction that spans all nodes in a cluster. This is used when
 * replicating all modifications in a transaction; the PREPARE and COMMIT (or ROLLBACK)
 * messages have to have a unique identifier to associate the changes with<br>
 *
 * @author <a href="mailto:bela@jboss.org">Bela Ban</a> Apr 12, 2003
 * @version $Revision: 1.4.2.6 $
 */
public class GlobalTransaction implements Externalizable {
   Address addr=null;
   long id=-1;
   private static long sid=1;

   public GlobalTransaction() {
      ; // used by externalization
   }

   private GlobalTransaction(Address addr) {
      this.addr=addr;
      id=newId();
   }

   private static synchronized long newId() {
      return ++sid;
   }

   public static GlobalTransaction create(Address addr) {
      return new GlobalTransaction(addr);
   }

   public Object getAddress() {
      return addr;
   }

   public long getId() {
      return id;
   }

   public int hashCode() {
      return (addr != null ? addr.hashCode() : 0) + (int)id;
   }

   public boolean equals(Object other) {
      if(other == null || !(other instanceof GlobalTransaction))
         return false;
      return compareTo(other) == 0;
   }

   public int compareTo(Object o) {
      GlobalTransaction other;
      int comp;
      if(o == null || !(o instanceof GlobalTransaction))
         throw new ClassCastException("GlobalTransaction.compareTo(): other object is " + o);
      other=(GlobalTransaction)o;
      comp=addr != null ? addr.compareTo(other.addr) : 0;
      if(comp != 0) return comp;
      if(id < other.getId()) return -1;
      if(id > other.getId()) return 1;
      return 0;
   }

   public String toString() {
      StringBuffer sb=new StringBuffer();
      sb.append('<').append(addr).append(">:").append(id);
      return sb.toString();
   }

   public void writeExternal(ObjectOutput out) throws IOException {
      out.writeObject(addr);
      out.writeLong(id);
   }

   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
      addr=(Address)in.readObject();
      id=in.readLong();
   }


}
