package org.jboss.cache;

import org.jgroups.blocks.MethodCall;

import java.util.List;

/**
 * Defines an entity able to receive replications
 * @author Bela Ban
 * @version $Id: Replicatable.java,v 1.1.4.3 2004/12/30 17:08:34 starksm Exp $
 */
public interface Replicatable {

   /**
    * Receives and applies a method call as result of replication
    * @param method_call
    * @return
    * @throws Throwable
    */
   Object replicate(MethodCall method_call) throws Throwable;

   /**
    * Receives and applies a number of method calls
    * @param method_calls
    * @throws Throwable
    */
   void replicate(List method_calls) throws Throwable;
}
