package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;

/**
 * Value object used in evicted event node queue.
 * @see org.jboss.cache.eviction.Region
 *
 * @author Ben Wang 2-2004
 */
public class EvictedEventNode
{
   // Signal the operation types.
   public static final Integer ADD_EVENT = new Integer(0);
   public static final Integer REMOVE_EVENT = new Integer(1);
   public static final Integer VISIT_EVENT = new Integer(2);

   private Fqn fqn_;
   private Integer event_;

   public EvictedEventNode(Fqn fqn, Integer event)
   {
      setFqn(fqn);
      setEvent(event);
   }

   public EvictedEventNode(String fqn)
   {
      setFqn(Fqn.fromString(fqn));
   }

   public Fqn getFqn()
   {
      return fqn_;
   }

   public void setFqn(Fqn fqn)
   {
      this.fqn_ = fqn;
   }

   public void setEvent(Integer event) {
      event_ = event;
   }

   public Integer getEvent() {
      return event_;
   }
}
