package org.jboss.cache.lock;

import org.jboss.cache.TreeCache;


/**
 * Interface for acquising and releasing locks on nodes of the cache. An implementation
 * knows the cache and how to acquire locks on nodes.
 *
 * @author <a href="mailto:bela@jboss.org">Bela Ban</a> Apr 9, 2003
 * @version $Revision: 1.1.2.6 $
 */
public interface LockManager
{

   /**
    * Can we read values changed in another (uncommitted) transaction ?
    * If true we can have read-locks; otherwise only write-locks will be acquired
    */
   boolean getDirtyReadsAllowed();

   void setDirtyReadsAllowed(boolean flag);

   /**
    * Acquires a read lock. If the lock cannot be acquired within the <tt>timeout</tt>,
    * a TimeoutExeption will be thrown. If the current thread already owns the read-lock,
    * or owns the write-lock, this will succeed.
    *
    * @param cache
    * @param fqn
    * @param timeout
    * @throws TimeoutException
    */
   void getReadLock(TreeCache cache, String fqn, long timeout) throws TimeoutException;

   /**
    * Acquires a write-lock. If the lock cannot be acquired within the <tt>timeout</tt>,
    * a TimeoutExeption will be thrown. If the current thread already owns the write-lock,
    * this will succeed. If the current thread own the read-lock, it will try to upgrade
    * the read-lock to write-lock status. If this fails, an UpgradeException will be thrown.
    *
    * @param cache
    * @param fqn
    * @param timeout
    * @throws TimeoutException
    */
   void getWriteLock(TreeCache cache, String fqn, long timeout)
         throws TimeoutException, UpgradeException;

   void releaseLock(String fqn, boolean release_children);

}
