// $Id: CacheImplMBean.java,v 1.1 2003/10/30 01:21:19 bwang00 Exp $

/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache;

import org.jboss.system.ServiceMBean;


/**
 * CacheImplMBean interface.
 *
 * @author  <a href="mailto:bela@jboss.org">Bela Ban</a>.
 * @version $Revision: 1.1 $
 *
 * <p><b>Revisions:</b>
 *
 * <p>Dec 27 2002 Bela Ban: first implementation
 */
public interface CacheImplMBean extends ServiceMBean, Cache {

    //ObjectName OBJECT_NAME = ObjectNameFactory.create("jboss:service=CacheImplMBean");

    /** Get the name of the replication group (e.g. JGroups) */
    String getClusterName();

    /** Set the name of the replication group */
    void setClusterName(String name);

    /** Get the cluster properties (e.g. the protocol stack specification in case of JGroups) */
    String getClusterProperties();

    /** Set the cluster properties. If the cache is to use the new properties, it has to be redeployed */
    void setClusterProperties(String cluster_properties);

    /** Get the maximum number of entries (cache eviction kicks in when reached) */
    int getMaxCapacity();

    /** Set the maximum number of entries (cache eviction kicks in when reached) */
    void setMaxCapacity(int max_capacity);

    /** Get the max time to wait until the initial state is retrieved.
     * This is used in a replicating cache: when a new cache joins the cluster,
     * it needs to acquire the (replicated) state of the other members to
     * initialize itself. If no state has been received within <tt>timeout</tt>
     * milliseconds, the map will be empty.
     * @return long Number of milliseconds to wait for the state. 0 means to
     * wait forever.
     */
    long getInitialStateRetrievalTimeout();

    /** Set the initial state transfer timeout (see {@link #getInitialStateRetrievalTimeout()}) */
    void setInitialStateRetrievalTimeout(long timeout);

    /** Returns the current default caching mode. Possible values are
     * <ul>
     * <li>TRANSIENT
     * <li>REPL_ASYNC
     * <li>REPL_SYNC
     * <ul>
     * @return int The caching mode
     */
    int getCachingMode();

    /** Sets the default caching mode (see {@link #setCachingMode(int)}) */
    void setCachingMode(int mode);

    /**
     * Returns the default max timeout after which synchronous replication calls
     * return.
     * @return long Number of milliseconds after which a sync repl call must
     * return. 0 means to wait forever
     */
    long getSyncReplTimeout();

    /** Sets the default maximum wait time for synchronous replication to receive all results */
    void setSyncReplTimeout(long timeout);

    /**
     * Default max time to wait for a lock. If the lock cannot be acquired
     * within this time, a LockingException will be thrown.
     * @return long Max number of milliseconds to wait for a lock to be acquired
     */
    long getLockAcquisitionTimeout();

    /** Set the max time for lock acquisition. A value of 0 means to wait forever (not recomended).
     * Note that lock acquisition timeouts may be removed in the future when we
     * have deadlock detection.
     * @param timeout
     */
    void setLockAcquisitionTimeout(long timeout);

    /** Max time a lock can be held. After this time the lock is released.
     * (Not currently used.)
     * @return long The max number of milliseconds to hold a lock
     */
    long getLockLeaseTimeout();

    /** Sets the max time a lock can be held */
    void setLockLeaseTimeout(long timeout);

    /** Returns the name of the cache eviction policy (must be an implementation
     * of EvictionPolicy)
     * @return Fully qualified name of a class implementing the EvictionPolicy
     * interface
     */
    String getEvictionPolicyClass();

    /** Sets the classname of the eviction policy */
    void setEvictionPolicyClass(String eviction_policy_classname);


    // TODO: add more eviction policy properties (e.g. eviction mode etc)


}
