// $Id: CacheValue.java,v 1.1 2003/10/30 01:21:19 bwang00 Exp $

/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;


/**
 * Wrapper for values in the hashmap. Contains aditional information about the
 * entry, such as caching mode (e.g. transient, replicated) etc.
 * @author Bela Ban
 * @version $Revision: 1.1 $
 * @see CacheKey
 */
public class CacheValue implements Externalizable {

    /** The wrapped value */
    Object value=null;

    /** True if this is a transient value (default = false) */
    boolean is_transient=false;


    /**
     * Constructor for CacheValue.
     */
    public CacheValue() {
        super();
    }

    public CacheValue(Object value) {
        this.value=value;
    }

    public CacheValue(Object value, boolean is_transient) {
        this.value=value;
        this.is_transient=is_transient;
    }


    /**
     * Returns the value.
     * @return Object
     */
    public Object getValue() {
        return value;
    }

    /**
     * Sets the value.
     * @param value The value to set
     */
    public void setValue(Object value) {
        this.value=value;
    }

    /**
     * Returns the is_transient.
     * @return boolean
     */
    public boolean isTransient() {
        return is_transient;
    }

    /**
     * Sets the is_transient.
     * @param is_transient The is_transient to set
     */
    public void setTransient(boolean is_transient) {
        this.is_transient=is_transient;
    }


    /**
     * @see java.io.Externalizable#readExternal(java.io.ObjectInput)
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if(in.readBoolean()) {
            value=in.readObject();
        }
        is_transient=in.readBoolean();
    }

    /**
     * @see java.io.Externalizable#writeExternal(java.io.ObjectOutput)
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        if(value != null) {
            out.writeBoolean(true);
            out.writeObject(value);
        }
        else {
            out.writeBoolean(false);
        }
        out.writeBoolean(is_transient);
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        StringBuffer sb=new StringBuffer();
        if(value != null)
            sb.append(value.toString());
        else
            sb.append("null");
        if(is_transient)
            sb.append(" (transient)");
        return sb.toString();
    }


}
