// $Id: EvictionPolicy.java,v 1.1 2003/10/30 01:21:19 bwang00 Exp $

/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 * Created on Jan 3, 2003
 */


package org.jboss.cache;

import org.jboss.system.Service;

/**
 * Interface to be implemented by cache eviction policy handlers. Implementation
 * may register as {@link CacheListener}s, and handle cache eviction (if
 * necessary) when an entry is added, or they may choose to run in a background
 * thread and periodically check cache size against specified max cache size.
 * <br/>
 * An eviction policy has a reference to the cache for which it performs
 * eviction. It can therefore read the properties of the cache and access the
 * cache's methods.
 * <br/> Since this class extends from {@link Service}, its
 * methods {@link org.jboss.system.Service#create()}, {@link org.jboss.system.Service#start()},
 * {@link org.jboss.system.Service#stop()} and
 * {@link org.jboss.system.Service#destroy()} will be called for lifecycle management.
 * @author Bela Ban
 * @version $Revision: 1.1 $
 */
public interface EvictionPolicy extends Service {

    /** The cache for which we do eviction. This is called before all other lifecycle callbacks */
    void setCache(CacheImpl c);
}
