/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.resource.adapter.jdbc.local;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.transaction.xa.XAResource;

import org.jboss.logging.Logger;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnection;

/**
 * LocalManagedConnection.java
 *
 *
 * Created: Mon Aug 12 19:18:58 2002
 *
 * @author <a href="mailto:d_jencks@users.sourceforge.net">David Jencks</a>
 * @version
 */

public class LocalManagedConnection
   extends BaseWrapperManagedConnection
   implements LocalTransaction
{
   public LocalManagedConnection (final LocalManagedConnectionFactory mcf,
                                  final Connection con,
                                  final Properties props,
                                  final int transactionIsolation,
                                  final int psCacheSize,
                                  final boolean doQueryTimeout)
      throws SQLException
   {
      super(mcf, con, props, transactionIsolation, psCacheSize, doQueryTimeout);
   }

   /**
    *
    * @return <description>
    * @exception javax.resource.ResourceException <description>
    */
   public LocalTransaction getLocalTransaction() throws ResourceException
   {
      return this;
   }

   /**
    *
    * @return <description>
    * @exception javax.resource.ResourceException <description>
    */
   public XAResource getXAResource() throws ResourceException
   {
      throw new JBossResourceException("Local tx only!");
   }

   // implementation of javax.resource.spi.LocalTransaction interface

   /**
    *
    * @exception javax.resource.ResourceException <description>
    */
   public void commit() throws ResourceException
   {
      synchronized (stateLock)
      {
         if (inManagedTransaction)
            inManagedTransaction = false;
         else
            throw new JBossResourceException("Trying to commit outside of a local tx");
      }
      try
      {
         con.commit();
      }
      catch (SQLException e)
      {
         checkException(e);
      }
   }

   /**
    *
    * @exception javax.resource.ResourceException <description>
    */
   public void rollback() throws ResourceException
   {
      synchronized (stateLock)
      {
         if (inManagedTransaction)
            inManagedTransaction = false;
         else
            throw new JBossResourceException("Trying to rollback outside of a local tx");
      }
      try
      {
         inManagedTransaction = false;
         con.rollback();
      }
      catch (SQLException e)
      {
         try
         {
             checkException(e);
         }
         catch (Exception e2) {}
      }
   }

   /**
    *
    * @exception javax.resource.ResourceException <description>
    */
   public void begin() throws ResourceException
   {
      synchronized (stateLock)
      {
         if (inManagedTransaction == false)
         {
            try
            {
               if (underlyingAutoCommit)
               {
                  underlyingAutoCommit = false;
                  con.setAutoCommit(false);
               }
               checkState();
               inManagedTransaction = true;
            }
            catch (SQLException e)
            {
               checkException(e);
            }
         }
         else
            throw new JBossResourceException("Trying to begin a nested local tx");
      }
   }



   /**
    * Describe <code>getProps</code> method here.
    * for the mcf to access in matchManagedConnection
    * @return a <code>Properties</code> value
    */
   Properties getProps()
   {
      return props;
   }


}// LocalManagedConnection
