/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.resource.adapter.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TopicConnection;

/**
 * A marker interface to join topics and queues into one factory.
 *
 * <p>Created: Thu Mar 29 15:37:21 2001
 *
 * @author  <a href="mailto:peter.antman@tim.se">Peter Antman</a>.
 * @version <pre>$Revision: 1.1.4.1 $</pre>
 */
public interface JmsSessionFactory
   extends Connection, TopicConnection, QueueConnection
{
   /**
    * Add a temporary queue
    * 
    * @param temp the temporary queue
    */
   void addTemporaryQueue(TemporaryQueue temp);

   /**
    * Add a temporary topic
    * 
    * @param temp the temporary topic
    */
   void addTemporaryTopic(TemporaryTopic temp);
   
   /** 
    * Notification that a session is closed
    * 
    * @throws JMSException for any error 
    */
   void closeSession(JmsSession session) throws JMSException;
}
