package org.jboss.console.twiddle.command;

import java.util.Comparator;

/** A comparator that compares ops based on name and argument count.
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1 $
 */
public class OpCountComparator implements Comparator
{
   public int compare(Object o1, Object o2)
   {
      MBeanOp op1 = (MBeanOp) o1;
      MBeanOp op2 = (MBeanOp) o2;
      int compare = op1.getName().compareTo(op2.getName());
      if( compare == 0 )
         compare = op1.getArgCount() - op2.getArgCount();
      return compare;
   }
}
