package org.apache.axis.message;

import org.xml.sax.Attributes;

/**
 * Null implementation of the Attributes interface.
 *
 * @author David Megginson
 * @author Sam Ruby <rubys@us.ibm.com>
 */
public class NullAttributes implements Attributes
{

   public static final NullAttributes singleton = new NullAttributes();

   ////////////////////////////////////////////////////////////////////
   // Implementation of org.xml.sax.Attributes.
   ////////////////////////////////////////////////////////////////////


   /**
    * Return the number of attributes in the list.
    *
    * @return The number of attributes in the list.
    * @see org.xml.sax.Attributes#getLength
    */
   public int getLength()
   {
      return 0;
   }


   /**
    * Return an attribute's Namespace URI.
    *
    * @param index The attribute's index (zero-based).
    * @return The Namespace URI, the empty string if none is
    *         available, or null if the index is out of range.
    * @see org.xml.sax.Attributes#getURI
    */
   public String getURI(int index)
   {
      return null;
   }


   /**
    * Return an attribute's local name.
    *
    * @param index The attribute's index (zero-based).
    * @return The attribute's local name, the empty string if
    *         none is available, or null if the index if out of range.
    * @see org.xml.sax.Attributes#getLocalName
    */
   public String getLocalName(int index)
   {
      return null;
   }


   /**
    * Return an attribute's qualified (prefixed) name.
    *
    * @param index The attribute's index (zero-based).
    * @return The attribute's qualified name, the empty string if
    *         none is available, or null if the index is out of bounds.
    * @see org.xml.sax.Attributes#getQName
    */
   public String getQName(int index)
   {
      return null;
   }


   /**
    * Return an attribute's type by index.
    *
    * @param index The attribute's index (zero-based).
    * @return The attribute's type, "CDATA" if the type is unknown, or null
    *         if the index is out of bounds.
    * @see org.xml.sax.Attributes#getType(int)
    */
   public String getType(int index)
   {
      return null;
   }


   /**
    * Return an attribute's value by index.
    *
    * @param index The attribute's index (zero-based).
    * @return The attribute's value or null if the index is out of bounds.
    * @see org.xml.sax.Attributes#getValue(int)
    */
   public String getValue(int index)
   {
      return null;
   }


   /**
    * Look up an attribute's index by Namespace name.
    * <p/>
    * <p>In many cases, it will be more efficient to look up the name once and
    * use the index query methods rather than using the name query methods
    * repeatedly.</p>
    *
    * @param uri       The attribute's Namespace URI, or the empty
    *                  string if none is available.
    * @param localName The attribute's local name.
    * @return The attribute's index, or -1 if none matches.
    * @see org.xml.sax.Attributes#getIndex(java.lang.String,java.lang.String)
    */
   public int getIndex(String uri, String localName)
   {
      return -1;
   }


   /**
    * Look up an attribute's index by qualified (prefixed) name.
    *
    * @param qName The qualified name.
    * @return The attribute's index, or -1 if none matches.
    * @see org.xml.sax.Attributes#getIndex(java.lang.String)
    */
   public int getIndex(String qName)
   {
      return -1;
   }


   /**
    * Look up an attribute's type by Namespace-qualified name.
    *
    * @param uri       The Namespace URI, or the empty string for a name
    *                  with no explicit Namespace URI.
    * @param localName The local name.
    * @return The attribute's type, or null if there is no
    *         matching attribute.
    * @see org.xml.sax.Attributes#getType(java.lang.String,java.lang.String)
    */
   public String getType(String uri, String localName)
   {
      return null;
   }


   /**
    * Look up an attribute's type by qualified (prefixed) name.
    *
    * @param qName The qualified name.
    * @return The attribute's type, or null if there is no
    *         matching attribute.
    * @see org.xml.sax.Attributes#getType(java.lang.String)
    */
   public String getType(String qName)
   {
      return null;
   }


   /**
    * Look up an attribute's value by Namespace-qualified name.
    *
    * @param uri       The Namespace URI, or the empty string for a name
    *                  with no explicit Namespace URI.
    * @param localName The local name.
    * @return The attribute's value, or null if there is no
    *         matching attribute.
    * @see org.xml.sax.Attributes#getValue(java.lang.String,java.lang.String)
    */
   public String getValue(String uri, String localName)
   {
      return null;
   }


   /**
    * Look up an attribute's value by qualified (prefixed) name.
    *
    * @param qName The qualified name.
    * @return The attribute's value, or null if there is no
    *         matching attribute.
    * @see org.xml.sax.Attributes#getValue(java.lang.String)
    */
   public String getValue(String qName)
   {
      return null;
   }
}
