/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.axis.message;

import org.w3c.dom.NodeList;

import java.util.ArrayList;
import java.util.List;

/**
 * A simple implementation for Nodelist that holds soap nodes
 *
 * @author Thomas Diesler (thomas.diesler@jboss.org)
 */
class SOAPNodeList implements NodeList
{

   private List nodeList = new ArrayList();

   /**
    * Constructor and Setter is intensionally made package protected only
    */
   SOAPNodeList()
   {
   }

   SOAPNodeList(List nodes)
   {
      nodeList = new ArrayList(nodes);
   }

   void addNode(javax.xml.soap.Node node)
   {
      nodeList.add(node);
   }

   // org.w3c.dom.NodeList ********************************************************************************************

   public org.w3c.dom.Node item(int index)
   {

      if (-1 < index && index < nodeList.size())
         return (javax.xml.soap.Node)nodeList.get(index);
      else
         return null;
   }

   public int getLength()
   {
      return nodeList.size();
   }
}
