/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *    Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.axis.server;

import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import java.util.Map;

/**
 * Helper class for obtaining AxisServers, which hides the complexity
 * of JNDI accesses, etc.
 * <p/>
 * !!! QUESTION : Does this class need to play any ClassLoader tricks?
 *
 * @author Glen Daniels (gdaniels@macromedia.com)
 */

public class JNDIAxisServerFactory extends DefaultAxisServerFactory
{

   private static Logger log = Logger.getLogger(JNDIAxisServerFactory.class.getName());

   /**
    * Obtain an AxisServer reference, using JNDI if possible, otherwise
    * creating one using the standard Axis configuration pattern.  If we
    * end up creating one and do have JNDI access, bind it to the passed
    * name so we find it next time.
    * <p/>
    * NOTE : REQUIRES SERVLET 2.3 FOR THE GetServletContextName() CALL!
    *
    * @param environment The following is used, in addition to
    *                    the keys used by the parent class:
    *                    AxisEngine.ENV_SERVLET_CONTEXT
    *                    [required, else default/parent behavior]
    *                    - Instance of ServletContext
    */
   public AxisServer getServer(Map environment)
           throws AxisFault
   {
      log.debug("Enter: JNDIAxisServerFactory::getServer");

      InitialContext context = null;

      // First check to see if JNDI works
      // !!! Might we need to set up context parameters here?
      try
      {
         context = new InitialContext();
      }
      catch (NamingException e)
      {
         log.warn(Messages.getMessage("jndiNotFound00"), e);
      }

      ServletContext servletContext = null;
      try
      {
         servletContext =
                 (ServletContext)environment.get(AxisEngine.ENV_SERVLET_CONTEXT);
      }
      catch (ClassCastException e)
      {
         log.warn(Messages.getMessage("servletContextWrongClass00"), e);
         // Fall through
      }

      AxisServer server = null;
      if (context != null && servletContext != null)
      {
         // Figure out the name by looking in the servlet context (for now)

         /**
          * !!! WARNING - THIS CLASS NEEDS TO FIGURE OUT THE CORRECT
          * NAMING SCHEME FOR GETTING/PUTTING SERVERS FROM/TO JNDI!
          *
          */

         // For servlet 2.3....?
         // String name = servletContext.getServletContextName();

         // THIS IS NOT ACCEPTABLE JNDI NAMING...
         String name = servletContext.getRealPath("/WEB-INF/Server");

// The following was submitted as a patch, but I don't believe this
// is going to produce a valid JNDI name of ANY sort... yuck.
// This would produce a URL, not a path name.
//
// Since it appears, from comments above, that this entire scheme is
// broken, then for now I'll simply check for a null-name to prevent
// possible NPE on WebLogic.
//
// What ARE we doing here?!?!
//            
//            if (name == null) {
//                try {
//                    name = servletContext.getResource("/WEB-INF/Server").toString();
//                } catch (Exception e) {
//                    // ignore
//                }
//            }

         // We've got JNDI, so try to find an AxisServer at the
         // specified name.
         if (name != null)
         {
            try
            {
               server = (AxisServer)context.lookup(name);
            }
            catch (NamingException e)
            {
               // Didn't find it.
               server = super.getServer(environment);
               try
               {
                  context.bind(name, server);
               }
               catch (NamingException e1)
               {
                  // !!! Couldn't do it, what should we do here?
               }
            }
         }
      }

      if (server == null)
      {
         server = super.getServer(environment);
      }

      log.debug("Exit: JNDIAxisServerFactory::getServer");

      return server;
   }
}
