/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id: ServiceClassLoaderAwareWSDDHandlerProvider.java,v 1.3.2.2 2004/08/08 21:27:33 tdiesler Exp $
package org.jboss.net.axis;

import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.deployment.wsdd.providers.WSDDHandlerProvider;

/**
 * <p>
 * A subclass of the official handler provider that
 * is able to load the specified handler classes from
 * the service deployment classloader.
 * </p>
 * @author jung
 * @since 12.03.2003
 * @version $Revision: 1.3.2.2 $
 */

public class ServiceClassLoaderAwareWSDDHandlerProvider
   extends WSDDHandlerProvider
{

   /* (non-Javadoc)
    * @see org.apache.axis.deployment.wsdd.WSDDProvider#newProviderInstance(org.apache.axis.deployment.wsdd.WSDDService, org.apache.axis.EngineConfiguration)
    */
   public Handler newProviderInstance(
      WSDDService arg0,
      EngineConfiguration arg1)
      throws Exception
   {

      Deployment deployment = (Deployment) arg0.getParametersTable().
         get(Constants.SERVICE_DEPLOYMENT_PARAMETER);

      if (deployment != null)
      {
         ClassLoader loader = deployment.getDeploymentLoader();
         ClassLoader old = Thread.currentThread().getContextClassLoader();
         Thread.currentThread().setContextClassLoader(loader);
         try
         {
            return super.newProviderInstance(arg0, arg1);
         }
         finally
         {
            Thread.currentThread().setContextClassLoader(old);
         }
      }
      else
      {
         return super.newProviderInstance(arg0, arg1);
      }
   }

}
