/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 * Created on Jan 22, 2004
 */
package org.jboss.net.axis.security;

import javax.security.auth.x500.X500Principal;

import org.apache.ws.security.components.crypto.Crypto;

/**
 * <dl>
 * <dt><b>Title: </b><dd>JBoss Crypto</dd>
 * <p>
 * <dt><b>Description: </b><dd>This is an extension of the wss4j Crypto interface that adds the 
 * getAliasForX500Principal method. This method is used to get a key alias for use durring authentication.</dd>
 * <p>
 * </dl>
 * @author <a href="mailto:jasone@greenrivercomputing.com">Jason Essington</a>
 * @version $Revision: 1.1.6.1 $
 */
public interface JBossCrypto extends Crypto
{
   public String getAliasForX500Principal(X500Principal dn) throws Exception;
}
