/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id: MBeanNotificationInfoSer.java,v 1.4.6.1 2004/08/08 21:28:04 tdiesler Exp $

package org.jboss.net.jmx.adaptor;

import org.apache.axis.Constants;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

import javax.management.*;
import javax.xml.namespace.QName;
import java.io.IOException;

/**
 * An <code>MBeanNotificationInfoSer</code> is be used to serialize
 * MBeanNotificationInfo using the <code>SOAP-ENC</code>
 * encoding style.<p>
 *
 * @author <a href="mailto:a_taherkordi@users.sourceforge.net">Alireza Taherkordi</a>
 * @version $Revision: 1.4.6.1 $
 */
public class MBeanNotificationInfoSer implements Serializer
{

   public void serialize(
      QName name,
      Attributes attributes,
      Object value,
      SerializationContext context)
      throws IOException
   {
      if (!(value instanceof MBeanNotificationInfo))
         throw new IOException(
            "Can't serialize a "
            + value.getClass().getName()
            + " instance with a MBeanNotificationInfo Serializer.");
      context.startElement(name, attributes);

      MBeanNotificationInfo info = (MBeanNotificationInfo) value;
      context.serialize(
         new QName("", "notifTypes"),
         null,
         info.getNotifTypes());
      context.serialize(new QName("", "name"), null, info.getName());
      context.serialize(
         new QName("", "description"),
         null,
         info.getDescription());

      context.endElement();
      return;

   }

   public Element writeSchema(Class aClass, Types types) throws Exception
   {
      return null;
   }

   public String getMechanismType()
   {
      return Constants.AXIS_SAX;
   }

}