
package org.jboss.mx.remoting.event;

import javax.management.*;
import java.io.Serializable;
import java.util.Arrays;

/**
 * CompositeQueryExp is a composite QueryExp that allows multiple QueryExp implementations to be
 * chained together (a little easier than trying to use Query class).

 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.1.2.1 $
 */
public class CompositeQueryExp implements QueryExp, Serializable
{
    static final long serialVersionUID = 1L;

    public static final int AND = 0;
    public static final int OR  = 1;

    private int operator;
    private QueryExp exps[];

    /**
     * create a composite QueryExp with the default <tt>AND</tt> operator
     *
     * @param exp
     */
    public CompositeQueryExp(QueryExp exp[])
    {
       this(exp,AND);
    }
    public CompositeQueryExp(QueryExp exp[], int operator)
    {
      this.exps=exp;
      this.operator = operator;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof CompositeQueryExp)) return false;

        final CompositeQueryExp compositeQueryExp = (CompositeQueryExp) o;

        if (operator != compositeQueryExp.operator) return false;
        if (!Arrays.equals(exps, compositeQueryExp.exps)) return false;

        return true;
    }

    public int hashCode()
    {
        int hash = operator;
        for (int c=0;c<exps.length;c++)
        {
           hash+=exps[c].hashCode();
        }
        return hash;
    }

    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException
    {
        for (int c=0;c<exps.length;c++)
        {
            if (exps[c]!=null)
            {
                boolean value = exps[c].apply(objectName);
                if (value && operator == OR)
                {
                    return true;
                }
                else if (!value && operator == AND)
                {
                    return false;
                }
            }
        }
        return (operator == AND) ? true : false;
    }

    public void setMBeanServer(MBeanServer mBeanServer)
    {
        for (int c=0;c<exps.length;c++)
        {
            if (exps[c]!=null)
            {
                exps[c].setMBeanServer(mBeanServer);
            }
        }
    }

    public String toString()
    {
        return "org.jboss.mx.remoting.event.CompositeQueryExp{" +
                "operator=" + operator +
                ", exps=" + (exps == null ? null : "length:" + exps.length + Arrays.asList(exps)) +
                "}";
    }

}
