/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.mx.remoting.tracker;

import org.jboss.mx.remoting.MBeanLocator;

import javax.management.Notification;

/**
 * MBeanTrackerActionAdapter is an adapter for the MBeanTrackerAction
 * interface so that subclasses can just specialize the appropriate
 * methods that need.
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.1.2.1 $
 */
public class MBeanTrackerActionAdapter implements MBeanTrackerAction
{
    /**
     * called when an MBean is unregistered with the MBeanServer
     *
     * @param locator
     */
    public void mbeanUnregistered(MBeanLocator locator)
    {

    }

    /**
     * called when the mbean state changes.  Note: this method will only be called on MBeans that have a
     * <tt>State</tt> attribute and where state change attribute notifications are fired
     *
     * @param locator
     * @param oldState
     * @param newState
     */
    public void mbeanStateChanged(MBeanLocator locator, int oldState, int newState)
    {

    }

    /**
     * called when a mbean notification is fired
     *
     * @param locator
     * @param notification
     * @param handback
     */
    public void mbeanNotification(MBeanLocator locator, Notification notification, Object handback)
    {

    }

    /**
     * called when an MBean is registered with the MBeanServer
     *
     * @param locator
     */
    public void mbeanRegistered(MBeanLocator locator)
    {

    }
}
