package org.jboss.test.mx.remoting.pingpong;

import org.apache.log4j.Level;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Appender;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.PortUtil;
import org.w3c.dom.Document;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.ByteArrayInputStream;
import java.util.Enumeration;

/**
 * a simple ping pong test that will send notifications and make remote
 * JMX invocations back and forth to other ping pong mbeans on the network
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @version $Revision: 1.1.2.2 $
 */
public class PingPongTest
{

    public static void main(String[] args)
    {
        try
        {
            org.apache.log4j.BasicConfigurator.configure();

            Enumeration e = org.apache.log4j.Category.getRoot().getAllAppenders();
            while(e.hasMoreElements())
            {
                Appender appender=(Appender)e.nextElement();
                if (appender.getClass().equals(ConsoleAppender.class))
                {
                    if (appender.getName()!=null)
                    {
                        org.apache.log4j.Category.getRoot().removeAppender(appender);
                    }
                }
            }

//            org.apache.log4j.Category.getRoot().removeAllAppenders();
//            org.apache.log4j.Category.getRoot().setLevel(Level.INFO);
//            org.apache.log4j.Category.getRoot().addAppender(new ConsoleAppender());

            System.setProperty("jboss.identity",Identity.createUniqueID());
            MBeanServer server = MBeanServerFactory.createMBeanServer();

            System.out.println("my identity is: "+Identity.get(server));


            NetworkRegistry registry = NetworkRegistry.getInstance();
            server.registerMBean(registry, new ObjectName(NetworkRegistry.OBJECT_NAME));
            registry.start();

            int port = PortUtil.findFreePort();

            Connector connector = new Connector();
            InvokerLocator locator = new InvokerLocator("socket://localhost:" + port);
            StringBuffer buf = new StringBuffer();
            buf.append("<?xml version=\"1.0\"?>\n");
            buf.append("<handlers>\n");
            buf.append("  <handler subsystem=\"JMX\">org.jboss.mx.remoting.JMXSubsystemInvocationHandler</handler>\n");
            buf.append("</handlers>\n");
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(buf.toString().getBytes()));
            connector.setInvokerLocator(locator.getLocatorURI());
            connector.setConfiguration(xml.getDocumentElement());
            ObjectName obj = new ObjectName("jboss.remoting:type=Connector,transport=" + locator.getProtocol());
            server.registerMBean(connector, obj);

            connector.start();

            MulticastDetector detector = new MulticastDetector();
            detector.setPort(Integer.parseInt(System.getProperty("detector.port","5555")));
            server.registerMBean(detector, new ObjectName("remoting:type=Detector,transport=multicast"));
            detector.start();

            PingPong pp = new PingPong();
            ObjectName objName = new ObjectName("test:type=PingPong");
            server.registerMBean(pp, objName);
        }
        catch(Throwable e)
        {
            e.printStackTrace();
        }
    }
}
