package org.jboss.test.mx.remoting.simple;

import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkRegistry;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class RemotingClientTest
{
   public static void main(String[] args)
   {
      try
      {
         System.setProperty("jboss.identity", Identity.createUniqueID());
         MBeanServer server = MBeanServerFactory.createMBeanServer();

         NetworkRegistry registry = NetworkRegistry.getInstance();
         server.registerMBean(registry, new ObjectName(NetworkRegistry.OBJECT_NAME));
         registry.start();

         MulticastDetector detector = new MulticastDetector();
         detector.setPort(Integer.parseInt(System.getProperty("detector.port", "5555")));
         ObjectName detObjName = new ObjectName("remoting:type=Detector,transport=multicast");
         server.registerMBean(detector, detObjName);

         RemotingClient rclient = new RemotingClient();
         server.addNotificationListener(detObjName, rclient, null, null);
         detector.start();
      }
      catch (Throwable e)
      {
         e.printStackTrace();
      }
   }
}
