package org.jboss.test.mx.remoting.simple;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.PortUtil;
import org.w3c.dom.Document;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.ByteArrayInputStream;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class RemotingServerTest
{
   public static void main(String[] args)
   {
      try
      {
         System.setProperty("jboss.identity", Identity.createUniqueID());
         MBeanServer server = MBeanServerFactory.createMBeanServer();

         NetworkRegistry registry = NetworkRegistry.getInstance();
         server.registerMBean(registry, new ObjectName(NetworkRegistry.OBJECT_NAME));
         registry.start();

         int port = PortUtil.findFreePort();

         Connector connector = new Connector();
         InvokerLocator locator = new InvokerLocator("socket://localhost:" + port);
         StringBuffer buf = new StringBuffer();
         buf.append("<?xml version=\"1.0\"?>\n");
         buf.append("<handlers>\n");
         buf.append("  <handler subsystem=\"JMX\">org.jboss.mx.remoting.JMXSubsystemInvocationHandler</handler>\n");
         buf.append("</handlers>\n");
         Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(buf.toString().getBytes()));
         connector.setInvokerLocator(locator.getLocatorURI());
         connector.setConfiguration(xml.getDocumentElement());
         ObjectName obj = new ObjectName("jboss.remoting:type=Connector,transport=" + locator.getProtocol());
         server.registerMBean(connector, obj);

         connector.start();

         MulticastDetector detector = new MulticastDetector();
         detector.setPort(Integer.parseInt(System.getProperty("detector.port", "5555")));
         server.registerMBean(detector, new ObjectName("remoting:type=Detector,transport=multicast"));
         detector.start();

         RemotingServer rsvr = new RemotingServer();
         ObjectName objName = new ObjectName("test:type=RemotingServer");
         server.registerMBean(rsvr, objName);
      }
      catch (Throwable e)
      {
         e.printStackTrace();
      }
   }
}
