/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

import org.jboss.mx.util.MetaDataUtil;

/**
 * Describes an argument of an operation exposed by an MBean
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>
 *
 * @version $Revision: 1.2.8.2 $
 *
 * <p><b>Revisions:</b>
 * <p><b>20020711 Adrian Brock:</b>
 * <ul>
 * <li> Serialization </li>
 * </ul>
 */
public class MBeanParameterInfo extends MBeanFeatureInfo
   implements java.io.Serializable, Cloneable
{
   // Constants -----------------------------------------------------

   private static final long serialVersionUID = 7432616882776782338L;

   // Attributes ----------------------------------------------------
   protected String type = null;

   /**
    * The cached string
    */
   private transient String cacheString;

   /**
    * The cached hashCode
    */
   private transient int cacheHashCode;

   // Constructors --------------------------------------------------
   public MBeanParameterInfo(java.lang.String name,
                             java.lang.String type,
                             java.lang.String description)
   {
      super(name, description);
      if (MetaDataUtil.isValidJavaType(type) == false)
         throw new IllegalArgumentException("type is not a valid java type (or is a reserved word): " + type);

      this.type = type;
   }


   // Public --------------------------------------------------------
   public java.lang.String getType()
   {
      return type;
   }

   public boolean equals(Object object)
   {
      if (this == object)
         return true;
      if (object == null || (object instanceof MBeanParameterInfo) == false)
         return false;

      MBeanParameterInfo other = (MBeanParameterInfo) object;

      if (super.equals(other) == false)
         return false;
      if (this.getType().equals(other.getType()) == false)
         return false;

      return true;
   }

   public int hashCode()
   {
      if (cacheHashCode == 0)
      {
         cacheHashCode =  super.hashCode();
         cacheHashCode += getType().hashCode();
      }
      return cacheHashCode;
   }

   /**
    * @return a human readable string
    */
   public String toString()
   {
      if (cacheString == null)
      {
         StringBuffer buffer = new StringBuffer(100);
         buffer.append(getClass().getName()).append(":");
         buffer.append(" name=").append(getName());
         buffer.append(" description=").append(getDescription());
         buffer.append(" type=").append(getType());
         cacheString = buffer.toString();
      }
      return cacheString;
   }

   // Cloneable implementation --------------------------------------
   public java.lang.Object clone() throws CloneNotSupportedException
   {
      MBeanParameterInfo clone = (MBeanParameterInfo) super.clone();
      clone.type = getType();
      return clone;
   }
}
