/*
* JBoss, the OpenSource EJB server
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package javax.management.monitor;
import javax.management.ObjectName;

/**
 * An observed object
 */
/* package */ class ObservedObject
{
  // Constants -----------------------------------------------------
  
  // Attributes ----------------------------------------------------
  
  /**
   * The object name.
   */
  private ObjectName objectName;
  
  /**
   * The notified attribute.
   */
  private int alreadyNotified = Monitor.RESET_FLAGS_ALREADY_NOTIFIED;
  
  /**
   * The derived gauge.
   */
  private Object derivedGauge;
  
  /**
   * The last value.
   */
  private Object lastValue;
  
  /**
   * The derived gauge timestamp.
   */
  private long derivedGaugeTimeStamp;
  
  /**
   * The threshold.
   */
  private Object threshold;

  // Static --------------------------------------------------------
  
  // Constructors --------------------------------------------------

  /**
   * Construct a new observed object.
   *
   * @param objectName the object name.
   */
  ObservedObject(ObjectName objectName)
  {
     if (objectName == null)
        throw new IllegalArgumentException("Null object name");
     this.objectName = objectName;
  }

  // Public --------------------------------------------------------

  ObjectName getObjectName()
  {
     return objectName;
  }

  int getAlreadyNotified()
  {
     return alreadyNotified;
  }

  boolean isAlreadyNotified(int mask)
  {
     return (alreadyNotified & mask) == 0;
  }

  boolean notAlreadyNotified(int mask)
  {
     if ((alreadyNotified & mask) == 0)
     {
        alreadyNotified |= mask;
        return true;
     }
     return false;
  }

  void setNotAlreadyNotified(int mask)
  {
     alreadyNotified &= ~mask;
  }

  void resetAlreadyNotified()
  {
     alreadyNotified = Monitor.RESET_FLAGS_ALREADY_NOTIFIED;
  }

  Object getDerivedGauge()
  {
     return derivedGauge;
  }

  void setDerivedGauge(Object gauge)
  {
     derivedGauge = gauge;
  }

  Object getLastValue()
  {
     return lastValue;
  }

  void setLastValue(Object last)
  {
     lastValue = last;
  }

  long getDerivedGaugeTimeStamp()
  {
     return derivedGaugeTimeStamp;
  }

  void setDerivedGaugeTimeStamp(long ts)
  {
     derivedGaugeTimeStamp = ts;
  }

  Object getThreshold()
  {
     return threshold;
  }

  void setThreshold(Object threshold)
  {
     this.threshold = threshold;
  }

  // X implementation ----------------------------------------------

  // Y overrides ---------------------------------------------------

   /**
    * @return human readable string.
    */
   public String toString()
   {
      StringBuffer buffer = new StringBuffer(100);
      buffer.append(getClass().getName()).append("@").append(System.identityHashCode(this)).append("{");
      buffer.append(" objectName=").append(getObjectName());
      buffer.append(" alreadyNotified=").append(getAlreadyNotified());
      return buffer.append("}").toString();
   }

  // Package protected ---------------------------------------------

  // Protected -----------------------------------------------------

  // Private -------------------------------------------------------

  // Inner classes -------------------------------------------------
}
