/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.mx.interceptor;

import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.InvocationException;
import org.jboss.mx.server.MBeanInvoker;

/** This interceptor returns the MBeanInfo from the invocation invoker. It
 * only makes sense to use this interceptor as the last interceptor in the
 * getMBeanInfo() call chain.
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.5.2.2 $
 */
public class ModelMBeanInfoInterceptor extends AbstractInterceptor
{
   public ModelMBeanInfoInterceptor()
   {
      super("Model MBeanInfo Interceptor");
   }

   public ModelMBeanInfoInterceptor(String name)
   {
      super("Model MBeanInfo Interceptor for " + name);
   }

   /** Return the MBeanInfo from the invocation MBeanInvoker
    * 
    * @param invocation
    * @return
    * @throws InvocationException
    */ 
   public Object invoke(Invocation invocation) throws InvocationException
   {
      MBeanInvoker invoker = invocation.getInvoker();
      return invoker.getMetaData();
   }
}
