/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.mx.interceptor;

import javax.management.MBeanException;
import javax.management.MBeanInfo;

import org.jboss.mx.metadata.MBeanInfoConversion;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.InvocationException;

/**
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @version $Revision: 1.5.2.2 $
 */   
public class StandardMBeanInfoInterceptor extends AbstractInterceptor
{
   // cached info
   MBeanInfo standardInfo = null;
   
   public StandardMBeanInfoInterceptor()
   {
      // FIXME: xxx
      super("Standard MBeanInfo Interceptor for XXX");
   }
   
   public Object invoke(Invocation invocation) throws InvocationException
   {

      MBeanInfo info = null;
      
      try
      {
         info = (MBeanInfo)super.invoke(invocation);
      }
      catch (Throwable ignored)
      {
         log.trace("Ignoring error retrieving mbeaninfo", ignored);
      }

      if (standardInfo == null)
      {
         try
         {
            standardInfo = MBeanInfoConversion.stripAttributeOperations(
                  MBeanInfoConversion.toModelMBeanInfo(info), false);
         }
         catch (MBeanException e)
         {
            throw new InvocationException(e);
         }
      }
      return standardInfo; 
   }
}

