/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mx.loading;

import java.security.PrivilegedAction;
import java.security.AccessController;
import java.security.CodeSource;

/** An encapsulation creating a to string rep for a class using a
 * PrivilegedAction for getting the ProtectionDomain.
 * 
 * @version $Revision: 1.1.2.1 $
 * @author Scott.Stark@jboss.org
 */
class ClassToStringAction implements PrivilegedAction
{
   private StringBuffer buffer;
   private Class clazz;
      ClassToStringAction(Class clazz, StringBuffer buffer)
      {
         this.clazz = clazz;
         this.buffer = buffer;
      }
      public Object run()
      {
         if( clazz != null )
         {
            buffer.append(clazz.getName());
            buffer.append("@"+Integer.toHexString(clazz.hashCode()));
            CodeSource cs = clazz.getProtectionDomain().getCodeSource();
            buffer.append("<CodeSource: "+cs+">");
         }
         else
         {
            buffer.append("null");
         }
         return null;
      }
      static void toString(Class clazz, StringBuffer buffer)
      {
         PrivilegedAction action = new ClassToStringAction(clazz, buffer);
         AccessController.doPrivileged(action);
      }
}
