/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.mx.metadata;

import javax.management.DynamicMBean;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

/**
 * This class is a bit bogus.
 *
 * @author  <a href="mailto:trevor@protocool.com">Trevor Squires</a>.
 */
public class MBeanCapability
{
   public static final int DYNAMIC_MBEAN = 0x321;
   public static final int STANDARD_MBEAN = 0x123;
   public static final int NOT_AN_MBEAN = 0xc0de;

   protected int mbeanType = NOT_AN_MBEAN;
   protected Class mbeanClass = null;
   protected MBeanInfo standardInfo = null;

   public static MBeanCapability of(Class mbeanClass) throws NotCompliantMBeanException
   {
      if (null == mbeanClass)
      {
         throw new IllegalArgumentException("Class cannot be null");
      }

      if (StandardMBean.class.isAssignableFrom(mbeanClass))
      {
         MBeanCapability result = new MBeanCapability(mbeanClass);
         result.mbeanType = STANDARD_MBEAN;
         return result;
      }
      else if (DynamicMBean.class.isAssignableFrom(mbeanClass))
      {
         return new MBeanCapability(mbeanClass);
      }
      else if (StandardMetaData.findStandardInterface(mbeanClass) != null)
      {
         return new MBeanCapability(mbeanClass, new StandardMetaData(mbeanClass).build());
      }

      throw new NotCompliantMBeanException("Class does not expose a management interface: " + mbeanClass.getName());
   }

   protected MBeanCapability(Class mbeanClass)
   {
      mbeanType = DYNAMIC_MBEAN;
   }

   protected MBeanCapability(Class mbeanClass, MBeanInfo info)
   {
      mbeanType = STANDARD_MBEAN;
      standardInfo = info;
   }

   public int getMBeanType()
   {
      return mbeanType;
   }
}
