/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mx.modelmbean;

/**
 * Constants used with Model MBean implementations.
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @author Matt Munz
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 */
public interface ModelMBeanConstants
{
   // Model MBean notification type string -------------------------
   String GENERIC_MODELMBEAN_NOTIFICATION = "jmx.modelmbean.generic";
   
   
   // Model MBean resource types -----------------------------------
   
   /**
    * Default Model MBean resource type, <tt>"ObjectReference"</tt>.
    */
   String OBJECT_REF               = "ObjectReference";

   
   // Mandatory descriptor fields -----------------------------------
   
   /**
    * Descriptor field string, <tt>"name"</tt>. Note that all valid descriptors
    * should contain this field.
    */
   String NAME                     = "name";
   
   /**
    * Descriptor field string, <tt>"descriptorType"</tt>. Note that all valid
    * descriptors should contain this field.
    */
   String DESCRIPTOR_TYPE          = "descriptortype";
   
   /**
    * Descriptor field string, <tt>"role"</tt>.
    */
   String ROLE                     = "role";
   
   
   // Descriptor types ----------------------------------------------
   
   /**
    * MBean descriptor type string, <tt>"MBean"</tt>.
    */
   String MBEAN_DESCRIPTOR         = "MBean";
   
   /**
    * MBean attribute descriptor type string, <tt>"attribute"</tt>.
    */
   String ATTRIBUTE_DESCRIPTOR     = "attribute";
   
   /**
    * MBean operation descriptor type string, <tt>"operation"</tt>.
    */
   String OPERATION_DESCRIPTOR     = "operation";
   
   /**
    * MBean notification descriptor type string, <tt>"notification"</tt>.
    */
   String NOTIFICATION_DESCRIPTOR  = "notification";
   
   /**
    * MBean constructor descriptor type string, <tt>"operation"</tt>.<br>
    * NOTE: the <tt>role</tt> field will contain the value <tt>"constructor"</tt>
    * (see {@link #CONSTRUCTOR}).
    */
   String CONSTRUCTOR_DESCRIPTOR   = "constructor";
      
   /**
    * A convenience constant to use with 
    * {@link javax.management.modelmbean.ModelMBeanInfo#getDescriptors getDescriptors()}
    * to return the descriptors of all management interface elements 
    * (a <tt>null</tt> string).
    */
   String ALL_DESCRIPTORS          = null;
   
   
   // Operation roles -----------------------------------------------
   
   /**
    * Management operation role string, <tt>"getter"</tt>.
    */
   String GETTER                   = "getter";
   
   /**
    * Management operation role string, <tt>"setter"</tt>.
    */
   String SETTER                   = "setter";
   
   /**
    * Management operation role string, <tt>"constructor"</tt>.
    */
   String CONSTRUCTOR              = "constructor";
   
   
   // Optional descriptor fields ------------------------------------
   String VISIBILITY               = "visibility";
   String LOG                      = "log";
   String EXPORT                   = "export";
   String DISPLAY_NAME             = "displayName";
   String DEFAULT                  = "default";
   String VALUE                    = "value";
   String GET_METHOD               = "getMethod";
   String SET_METHOD               = "setMethod";
   String PERSIST_POLICY           = "persistPolicy";
   String PERSIST_PERIOD           = "persistPeriod";
   String PERSIST_NAME             = "persistName";
   String PERSIST_LOCATION         = "persistLocation";
   String CURRENCY_TIME_LIMIT      = "currencyTimeLimit";
   String LAST_RETURNED_TIME_STAMP = "lastReturnedTimestamp";
   String LAST_UPDATED_TIME_STAMP  = "lastUpdatedTimeStamp";
   String SEVERITY                 = "severity";
   /** */
   final static String INTERCEPTORS = "interceptors";
   /**
    * Indicates whether MBean Info should be stored.
    */
   String PERSIST_INFO  = "persistmbeaninfo";
   /**
    * Indicates the FQN of the resource class
    */
   String RESOURCE_CLASS  = "resourceClass";
   /**
    *  constant used by the 1.0 xmbean parser 
    * this defines the name of the descriptor used to designate the persistence manager 
    *  that is to be used for a given XMBean
    */
   String PERSISTENCE_MANAGER = "persistence-manager";
   
   /**
    * Used to store the JMX ObjectName of the MBean, so it can be referenced
    * by subsystem that may need it
    */
   String OBJECT_NAME = "objectname";
   
   
   // Visibility values ---------------------------------------------
   String HIGH_VISIBILITY          = "1";
   String NORMAL_VISIBILITY        = "2";
   String LOW_VISIBILITY           = "3";
   String MINIMAL_VISIBILITY       = "4";
   
   
   // Persistence policies ------------------------------------------
   String PM_ON_UPDATE             = "onupdate";
   String PM_NO_MORE_OFTEN_THAN    = "nomoreoftenthan";
   String PM_NEVER                 = "never";
   String PM_ON_TIMER              = "ontimer";
         
         
   // Cache policies ------------------------------------------------
   String CACHE_NEVER              = "0";
   String CACHE_ALWAYS             = "-1";
           
         
   // Constants for metadata objects --------------------------------
   boolean IS_READABLE             = true;
   boolean IS_WRITABLE             = true;
   boolean IS_IS                   = true;
 
 
   // Operation impact ----------------------------------------------
   String ACTION                   = "ACTION";
   String ACTION_INFO              = "ACTION_INFO";
   String INFO                     = "INFO";
   
   /**
    * Extended descriptor used in conjuction with DelegatingPersistenceManager
    * to specify an external MBean service that will be used as a factory
    * for creating AttributePersistenceManager objects.
    * 
    * If the descriptor is not specified, the ObjectName below will be used
    * as the default.
    */
   String DELEGATING_PM_SERVICE_DESCRIPTOR    = "attribute-persistence-service";
   String DELEGATING_PM_SERVICE_DEFAULT_VALUE = "jboss:service=AttributePersistenceService";

   /**
    * Extended descriptor used in conjuction with DelegatingPersistenceManager
    * to specify the operation name that will be called on the external MBean service
    * for creating AttributePersistenceManager objects.
    * 
    * If the descriptor is not specified, the default will apply
    */
   String DELEGATING_PM_OPERATION_DESCRIPTOR     = "attribute-persistence-operation";
   String DELEGATING_PM_OPERATION_DEFAULT_VALUE  = "apmCreate";

   /** The MBeanServer injection id type */
   final String MBEAN_SERVER_INJECTION_TYPE = "MBeanServerType";
   /** The MBeanInfo injection id type */
   final String MBEAN_INFO_INJECTION_TYPE = "MBeanInfoType";
   /** The ObjectName injection id type */
   final String OBJECT_NAME_INJECTION_TYPE = "ObjectNameType";
}

