/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mx.notification;

import javax.management.NotificationFilter;
import javax.management.NotificationListener;

/**
 * The default listener registration factory.
 * 
 * @see org.jboss.mx.notification.ListenerRegistry
 * @see org.jboss.mx.notification.ListenerRegistration
 * 
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision: 1.3.2.1 $
 */
public class DefaultListenerRegistrationFactory
   implements ListenerRegistrationFactory
{
   public ListenerRegistration create(NotificationListener listener,
                                      NotificationFilter filter,
                                      Object handback)
   {
      return new DefaultListenerRegistration(listener, filter, handback);
   }
}
