/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mx.notification;

import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

/**
 * The listener registration factory to create registrations
 * in the mbeanserver for an object name.
 * 
 * @see org.jboss.mx.notification.ListenerRegistry
 * @see org.jboss.mx.notification.ListenerRegistration
 * 
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision: 1.3.2.1 $
 */
public class MBeanServerListenerRegistrationFactory
   implements ListenerRegistrationFactory
{
   /**
    * The object name
    */
   private ObjectName name;

   /**
    * The broadcaster
    */
   private NotificationBroadcaster broadcaster;

   /**
    * Construct a listener registration factory for the given object name
    *
    * @param name the object name
    * @param name the notification broadcaster
    * @exception IllegalArgumentException for a null object name
    */
   public MBeanServerListenerRegistrationFactory(ObjectName name, NotificationBroadcaster broadcaster)
   {
      if (name == null)
         throw new IllegalArgumentException("Null name");
      this.name = name;
      this.broadcaster = broadcaster;
   }

   public ListenerRegistration create(NotificationListener listener,
                                      NotificationFilter filter,
                                      Object handback)
   {
      return new MBeanServerListenerRegistration(name, broadcaster, listener, filter, handback);
   }
}
