package org.jboss.mx.server;

import java.lang.reflect.Method;

/** A dispatcher used by the AbstractMBeanInvoker class for the attribute
 * getter and setter dispatch.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.2 $
 */
public class AttributeDispatcher
   extends ReflectedDispatcher
{
   private Method getter;
   private Method setter;

   public AttributeDispatcher(Object target, Method getter, Method setter)
   {
      super(target, getter);
      this.getter = getter;
      this.setter = setter;
   }

   /** Dispatch the attribute set or get. A get is identified by a dispatch
    * with a null args value.
    * 
    * @return the result of the attribute accessor invocation
    * @throws InvocationException
    */ 
   public Object dispatch(Object[] args) throws InvocationException
   {        
      Object value = null;
      try
      {
         if( args == null )
            value = getter.invoke(target, args);
         else
            value = setter.invoke(target, args);
      }
      catch (Throwable t)
      {
         handleInvocationExceptions(t);
         return null;
      }
      return value;
   }
}
