/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.mx.server;


import java.util.ArrayList;
import java.util.List;
import javax.management.Descriptor;
import javax.management.MBeanParameterInfo;


/**
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @author <a href="mailto:d_jencks@users.sourceforge.net">David Jencks</a>
 * @version $Revision: 1.7.2.4 $
 *
 */

public class InvocationContext
{

   // Constants -----------------------------------------------------
   public final static String OP_INVOKE             = "invoke";
   public final static String OP_GETATTRIBUTE       = "getAttribute";
   public final static String OP_SETATTRIBUTE       = "setAttribute";
   public final static String OP_GETMBEANINFO       = "getMBeanInfo";

   public final static String OPERATION_IMPACT   = "operation.impact";
   public final static String ATTRIBUTE_ACCESS   = "attribute.access";
   public final static Dispatcher NULL_DISPATCHER = new NullDispatcher();


   // Attributes ----------------------------------------------------

   private String attributeType = null;
   private String name = null;
   private String[] signature = null;
   private String type = null;
   private boolean isWritable = true;

   List interceptors = null;
   transient Dispatcher dispatcher = NULL_DISPATCHER;
   transient Object resource = null;
   transient Descriptor descriptor = null;
   transient AbstractMBeanInvoker invoker = null;

   // Public --------------------------------------------------------

   public final void copy(final InvocationContext src)
   {
      if (src == null)
         return;

      this.attributeType = src.attributeType;
      this.name = src.name;
      this.signature = src.signature;
      this.type = src.type;
      this.isWritable = src.isWritable;
      this.interceptors = src.interceptors;
      this.dispatcher = src.dispatcher;
      this.resource = src.resource;
      this.descriptor = src.descriptor;
      this.invoker = src.invoker;
   }


   public void setType(String type)
   {
      this.type = type;
   }

   public String getType()
   {
      return type;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public String getName()
   {
      return name;
   }

   void setSignature(String[] signature)
   {
      this.signature = signature;
   }

   void setSignature(MBeanParameterInfo[] signature)
   {
      this.signature = new String[signature.length];

      for (int i = 0; i < signature.length; ++i)
         this.signature[i] = signature[i].getType();

   }

   public String[] getSignature()
   {
      return signature;
   }

   public void setAttributeType(String attrType)
   {
      this.attributeType = attrType;
   }

   public String getAttributeType()
   {
      return attributeType;
   }

   public boolean isWritable()
   {
      return isWritable;
   }

   public void setWritable(boolean writable)
   {
      this.isWritable = writable;
   }

   public void setInterceptors(List interceptors)
   {
      // FIXME: make a copy
      this.interceptors = interceptors;
   }

   public List getInterceptors()
   {
      // FIXME: return a copy

      if (interceptors == null)
      {
         interceptors = new ArrayList();
      }

      return interceptors;
   }

   public void setDispatcher(Dispatcher d)
   {
      this.dispatcher = d;
   }

   public Dispatcher getDispatcher()
   {
      return dispatcher;
   }

   void setResource(Object o)
   {
      this.resource = o;
   }

   public Object getResource()
   {
      return resource;
   }

   public void setDescriptor(Descriptor d)
   {
      this.descriptor = d;
   }

   public Descriptor getDescriptor()
   {
      return descriptor;
   }

   public void setInvoker(AbstractMBeanInvoker mi)
   {
      this.invoker = mi;
   }

   public MBeanInvoker getInvoker()
   {
      return invoker;
   }

   static class NullDispatcher implements Dispatcher
   {
      public Object dispatch(Object[] args) throws InvocationException
      {
         return null;
      }
   }
}

