/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mx.util;

import javax.management.QueryExp;
import javax.management.ObjectName;
import javax.management.BadStringOperationException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadAttributeValueExpException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.InstanceNotFoundException;

/** 
 * MBean QueryExp to find all classes of a particular instance
 * @author bill@jboss.org
 * @version $Revision: 1.1.2.1 $
 */
public class InstanceOfQueryExp implements QueryExp
{
   MBeanServer server;
   String classname;

   public InstanceOfQueryExp(String classname)
   {
      this.classname = classname;
   }

   public boolean apply(ObjectName name)
           throws BadStringOperationException,
           BadBinaryOpValueExpException,
           BadAttributeValueExpException,
           InvalidApplicationException
   {
      try
      {
         return server.isInstanceOf(name, classname);
      }
      catch (InstanceNotFoundException e)
      {
         throw new InvalidApplicationException(name);
      }
   }

   public void setMBeanServer(MBeanServer server)
   {
      this.server = server;
   }
}
