/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package test.compliance.server.support;

import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

/**
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision: 1.3.2.1 $
 */
public class BroadcasterInvocationHandlerTest
   extends InvocationHandlerTest
   implements NotificationBroadcaster
{
   NotificationBroadcasterSupport emitter = new NotificationBroadcasterSupport();

   public void addNotificationListener(NotificationListener listener,
                                       NotificationFilter filter,
                                       Object handback)
   {
      emitter.addNotificationListener(listener, filter, handback);
   }

   public MBeanNotificationInfo[] getNotificationInfo()
   {
      String[] types = { "test" };
      return new MBeanNotificationInfo[]
      {
         new MBeanNotificationInfo(types, "name", "description")
      };
   }

   public void removeNotificationListener(NotificationListener listener)
      throws ListenerNotFoundException
   {
      emitter.removeNotificationListener(listener);
   }

   public void sendNotification()
   {
      Notification notification = new Notification("test", this, 1l);
      emitter.sendNotification(notification);
   }
}